# Description
This module provides a reporting channel (see report-errors and report-errors-electron packages) that reports an exception to the Watson backend, such that a useful failure ID will be generated. It is windows only. It can also be used independently, if so desired. 

# Getting the module
This package is published to the vsts internal npm repo. Please refer to their documentation for setting this up. One you are set up, all you need to do is add this package as a dependency and run npm install, as with any other package. 

# Requirements
To use this module, you must be either building ES6 or using type information like ES6-shim. The interface relies on Promises for anything but very basic usage. This type information must be available to the compiler either in a triple slash reference or by giving a type file to the compiler as an input. No additional ambient definitions are needed to use this, but any issues you have with building are likely not having these types available. Don't trust VS Code's type error messages until you get a successful build from the command line and restart it. 

This depends on the wer-api-windows package, which has native components that build during npm install. This imposes some requirements on the build machine. Please see the documentation there for details. 

This is tested against Node 4.1.1 and may need small rewrites for newer versions. 

# Usage
To use this module, import the `WatsonReporter` class and optionally the `WerConsent` enum directly from the module, and add it as a reporting channel to the error handler you are using (again, see the report-errors package). Alternatively, Just use it alone. The report function will return a promise that resolves once it is done, or rejects on failure. You will need to use the ProcessedStack class from "report-errors/advanced" and pass an instance to it. 

The constructor optionally takes an object with various properties:
`/**`
`* consent passed to the watson APIs`
`* default is not asked`
`*`
`* @type {WerConsent}`
`*/`
`consent?: WerConsent;`
`/**`
`* Marks a report as noncritical, so that it is sent silently`
`* It will not ask for consent, so you must provide sufficient consent through the consent parameter`
`*`
`* @type {boolean}`
`*/`
`nonCritical?: boolean;`
`/**`
`* Only used for testing. It will not actually send it,`
`* but it will create the file and print the paramters to the console.`
`*`
`* @type {boolean}`
`*/`
`sendReport?: boolean;`
`/**`
`* Where the report file should be placed. default is TEMP`
`*`
`* @type {string}`
`*/`
`reportDirectory?: string;`
`/**`
`* whether the report file should be kept or deleted after the report is sent.`
`* it is always kept if sendReport is set to false.`
`*`
`* @type {boolean}`
`*/`
`keepReportFile?: boolean;`


Note that the dialog, if shown, is blocking and no JS can execute until the user interacts with it. Test this if you plan to do anything other than report fatal crashes and the kill the app. 

# Contributing
I am open to suggestions, bugfixes, and pull requests. To do this:

*clone the repo, make a topic branch
*run npm install
*run typings install
*edit (VS Code recommended)
*run gulp build, tslint, clean, and test as required
*run gulp validate-for-publish to do all of these, plus, generating a tarball that can be published or used for local testing. It is in the lib folder. 